/*
 * File:     VideoFrameGrabber.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.player;

import java.awt.Image;


/**
 * Defines methods to be implemented by any class capable of grabbing images
 * from a video file or stream.
 *
 * @author Han Sloetjes
 */
public interface VideoFrameGrabber {
    /**
     * Grabs the current video frame and converts it to an Image object.
     *
     * @return the current video frame
     */
    public Image getCurrentFrameImage();

    /**
     * Grabs the frame for the specified time and converts it to an Image.
     *
     * @param time the media time to grab the frame for
     *
     * @return the frame image or null
     */
    public Image getFrameImageForTime(long time);
}
