/*
 * File:     PrefConstants.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 *
 */
package mpi.eudico.client.annotator.prefs;


/**
 * Interface defining some constants for reading and writing of preferences xml files.
 *
 * @author Han SLoetjes
 */
public interface PrefConstants {
    // elements

    /** Holds value of property DOCUMENT ME! */
    public static final String PREF = "pref";

    /** Holds value of property DOCUMENT ME! */
    public static final String PREF_GROUP = "prefGroup";

    /** Holds value of property DOCUMENT ME! */
    public static final String PREF_LIST = "prefList";

    /** Holds value of property DOCUMENT ME! */
    public static final String BOOLEAN = "Boolean";

    /** Holds value of property DOCUMENT ME! */
    public static final String INT = "Int";

    /** Holds value of property DOCUMENT ME! */
    public static final String LONG = "Long";

    /** Holds value of property DOCUMENT ME! */
    public static final String FLOAT = "Float";

    /** Holds value of property DOCUMENT ME! */
    public static final String DOUBLE = "Double";

    /** Holds value of property DOCUMENT ME! */
    public static final String STRING = "String";

    /** Holds value of property DOCUMENT ME! */
    public static final String OBJECT = "Object";

    // attributes

    /** Holds value of property DOCUMENT ME! */
    public static final String KEY_ATTR = "key";

    /** Holds value of property DOCUMENT ME! */
    public static final String CLASS_ATTR = "class";

    /** Holds value of property DOCUMENT ME! */
    public static final String VERS_ATTR = "version";
}
