package mpi.eudico.client.annotator.prefs.gui;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;

import mpi.eudico.client.annotator.prefs.PreferenceEditor;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import java.util.HashMap;
import java.util.Map;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * A panel for viewer related preferences.
 * 
 * @author Han Sloetjes
 * @version 1.0
  */
public class ViewerPanel extends JPanel implements PreferenceEditor {
    private int origNumSubtitles = 4;
    private JComboBox numSubCB;

    /**
     * Creates a new ViewerPanel instance
     */
    public ViewerPanel() {
        super();
        readPrefs();
        initComponents();
    }

    /**
     * Reads stored preferences.
     *
     */
    private void readPrefs() {
        Object val = Preferences.get("NumberOfSubtitleViewers", null);

        if (val instanceof Integer) {
            origNumSubtitles = ((Integer) val).intValue();
        }
    }

    private void initComponents() {
        setLayout(new GridBagLayout());

        Insets insets = new Insets(2, 0, 2, 0);

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        add(new JLabel(ElanLocale.getString("Tab.Subtitles")), gbc);

        JLabel numLabel = new JLabel(ElanLocale.getString(
                    "PreferencesDialog.Viewer.NumSubtitles"));
        numLabel.setFont(numLabel.getFont().deriveFont(Font.PLAIN));
        gbc.gridy = 1;
        add(numLabel, gbc);

        numSubCB = new JComboBox(new Integer[] { 1, 2, 3, 4, 5, 6, 7, 8 });
        numSubCB.setSelectedItem(origNumSubtitles);
        gbc.gridy = 2;
        add(numSubCB, gbc);

        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.weighty = 1.0;
        add(new JPanel(), gbc); // filler
    }

    /**
     * Returns a map of changed key-value pairs.
     *
     * @return a map of changed key-value pairs
     */
    public Map getChangedPreferences() {
        if (isChanged()) {
            Map<String, Object> chMap = new HashMap<String, Object>(1);

            if (origNumSubtitles != (Integer) numSubCB.getSelectedItem()) {
                chMap.put("NumberOfSubtitleViewers",
                    (Integer) numSubCB.getSelectedItem());
            }

            return chMap;
        }

        return null;
    }

    /**
     * Returns whether any preference item has been changed.
     *
     * @return true if anything has changed.
     */
    public boolean isChanged() {
        int count = (Integer) numSubCB.getSelectedItem();

        if (count != origNumSubtitles) {
            return true;
        }

        return false;
    }
}
