/*
 * File:     AvailabilityDetector.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.api;

import mpi.eudico.util.ExtClassLoader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import java.net.URL;

import java.util.*;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class AvailabilityDetector {
    private static HashMap audioRecognizers;
    private static HashMap videoRecognizers;
    private static ArrayList currentAudioRecognizerFilePaths;
    private static ArrayList currentVideoRecognizerFilePaths;

    /**
 * Check which recognizers are available for a list of media files
 * The potential recognizers are supposed to return implement the method:
 * 
 *         public boolean setMedia(ArrayList mediaFilePaths);
 * 
 * the boolean tells if the recognizer is able to handle the media.
 * 
 * @return an ArrayList with the available audio recognizers
 */
    public static HashMap getAudioRecognizers(ArrayList filePaths) {
        if (!filePaths.equals(currentAudioRecognizerFilePaths)) {
            currentAudioRecognizerFilePaths = filePaths;
            audioRecognizers = new HashMap();

            Recognizer potentialRecognizer;

            try {
                // internal coded recognizers
                String[] recognizerClassName = {
                    "mpi.eudico.client.annotator.recognizer.silence.SilenceRecognizer" /*,
"mpi.eudico.client.annotator.recognizer.silence.TestRecognizer"*/
                };

                for (int i = 0; i < recognizerClassName.length; i++) {
                    potentialRecognizer = (Recognizer) Class.forName(recognizerClassName[i])
                                                            .newInstance();

                    if (potentialRecognizer.setMedia(filePaths)) {
                        String name = potentialRecognizer.getName();
                        audioRecognizers.put(name, potentialRecognizer);
                    }
                }

                // add the external recognizers 
                Class[] implementors = ExtClassLoader.getInstance()
                                                     .getImplementingClasses(Recognizer.class);

                if ((implementors != null) && (implementors.length > 0)) {
                    for (int i = 0; i < implementors.length; i++) {
                        Class cl = implementors[i];

                        try {
                            potentialRecognizer = (Recognizer) cl.newInstance();

                            if (potentialRecognizer.setMedia(filePaths)) {
                                String name = potentialRecognizer.getName();
                                audioRecognizers.put(name, potentialRecognizer);
                            }
                        } catch (Exception exc) { // any exception
                            System.out.println(
                                "Cannot create new instance of: " + cl);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return audioRecognizers;
    }

    /**
 * Maybe add parameters for needed capabilities like file formats
 * 
 * @return an ArrayList with the available video recognizers
 */
    public static HashMap getVideoRecognizers(ArrayList filePaths) {
        if (!filePaths.equals(currentVideoRecognizerFilePaths)) {
            currentVideoRecognizerFilePaths = filePaths;

            videoRecognizers = new HashMap();

            // add the external recognizers
        }

        return videoRecognizers;
    }
}
