/*
 * File:     RecognizerHost.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.api;

import mpi.eudico.client.annotator.recognizer.data.*;

import java.util.ArrayList;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public interface RecognizerHost {
    /**
 * Called by a Recognizer to send a Segmentation object to the RecognizerHost
 * More than one Segmentation can be sent.
 * 
 * @param segmentation the Segmentation produced by the Recognizer.
 */
    public void addSegmentation(Segmentation segmentation);

    /**
 * Periodically called by a Recognizer to inform the RecognizerHost 
 * about the progress of the recognition task.
 * 
 * @param progress a float between 0.0 and 1.0 where 1.0 means that the recognizer has finished processing.
 */
    public void setProgress(float progress);

    /**
 * Called by a Recognizer to get examples of the pattern it is supposed to find in the signal.
 * 
 * @return an ArrayList with Selection objects.
 */
    public ArrayList getSelections();

    /**
 * Called by ELAN to get the recognition result.
 * 
 * @return an ArrayList with Segmentation objects.
 */
    public ArrayList getSegmentations();

    /**
 * Tells ELAN if there is one or more recognizer busy
 * 
 * @return true if there is some recognizing going on
 */
    public boolean isBusy();
}
