/*
 * File:     Boundary.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.data;


/**
 * Data container for a segment boundary
 * 
 * @author albertr
 *
 */
public class Boundary implements Comparable {
    /** Holds value of property DOCUMENT ME! */
    public long time;

    /** Holds value of property DOCUMENT ME! */
    public String label;

    /**
     * Creates a new Boundary instance
     *
     * @param time DOCUMENT ME!
     * @param label DOCUMENT ME!
     */
    public Boundary(long time, String label) {
        this.time = time;
        this.label = label;
    }

    /**
     * DOCUMENT ME!
     *
     * @param otherBoundary DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int compareTo(Object otherBoundary) {
        return (int) (time - ((Boundary) otherBoundary).time);
    }
}
