/*
 * File:     MediaDescriptor.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.data;


/**
 * Container class to hold information regarding media files
 * 
 * For an audio signal the MediaDescriptor consists of a full path
 * to the audio file and a channel number that is 1 for a mono signal
 * and 1 or 2 for a stereo signal. 
 * 
 * For video signals the attribute channel is for the time being undefined. 
 * 
 * @author albertr
 *
 */
public class MediaDescriptor {
    /** Holds value of property DOCUMENT ME! */
    public String mediaFilePath;

    /** Holds value of property DOCUMENT ME! */
    public int channel;

    /**
     * Creates a new MediaDescriptor instance
     */
    public MediaDescriptor() {
        this.mediaFilePath = "";
        this.channel = 1;
    }

    /**
     * Creates a new MediaDescriptor instance
     *
     * @param mediaFilePath DOCUMENT ME!
     */
    public MediaDescriptor(String mediaFilePath) {
        this.mediaFilePath = mediaFilePath;
        this.channel = 1;
    }

    /**
     * Creates a new MediaDescriptor instance
     *
     * @param mediaFilePath DOCUMENT ME!
     * @param channel DOCUMENT ME!
     */
    public MediaDescriptor(String mediaFilePath, int channel) {
        this.mediaFilePath = mediaFilePath;
        this.channel = channel;
    }
}
