/*
 * File:     Segment.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.data;


/**
 * Container class for segment data.
 * 
 * For an audio signal the Segment defines the begin time, end time and
 * the category (label) of a pattern in the signal domain.
 * 
 * Segments in the video domain will probably need more attributes
 * to define an area or trajectory of interest.
 * 
 * @author albertr
 *
 */
public class Segment {
    /** Holds value of property DOCUMENT ME! */
    public long beginTime; // begin time in milliseconds

    /** Holds value of property DOCUMENT ME! */
    public long endTime; // end time in milliseconds

    /** Holds value of property DOCUMENT ME! */
    public String label; // segment content label

    /**
     * Creates a new Segment instance
     */
    public Segment() {
        label = "";
    }

    /**
     * Creates a new Segment instance
     *
     * @param beginTime DOCUMENT ME!
     * @param endTime DOCUMENT ME!
     * @param label DOCUMENT ME!
     */
    public Segment(long beginTime, long endTime, String label) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.label = label;
    }
}
