/*
 * File:     SegmentationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.gui;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.List;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;


/**
 * A panel with, for now, one button to start the conversion from segmentations
 * and segments to tiers and annotations.
 *
 * @author Albert Russel, Han Sloetjes
 * @version 1.0
 */
public class SegmentationPanel extends JPanel implements ActionListener {
    private RecognizerHost host;
    private ViewerManager2 viewerManager;
    private TitledBorder border;
    private JButton makeSegmentationTier;

    /**
     * Creates a new SegmentationPanel instance
     *
     * @param host the recognizer host object
     * @param viewerManager the viewermanager (holding the reference to the
     *        target transcription)
     */
    public SegmentationPanel(RecognizerHost host, ViewerManager2 viewerManager) {
        this.host = host;
        this.viewerManager = viewerManager;

        border = new TitledBorder(ElanLocale.getString(
                    "Recognizer.SegmentationsPanel.Title"));
        setBorder(border);

        makeSegmentationTier = new JButton(ElanLocale.getString(
                    "Recognizer.SegmentationsPanel.Make.Tier"));
        makeSegmentationTier.addActionListener(this);
        add(makeSegmentationTier);
    }

    /**
     * Apply localized strings.
     */
    public void updateLocale() {
        border.setTitle(ElanLocale.getString(
                "Recognizer.SegmentationsPanel.Title"));
        makeSegmentationTier.setText(ElanLocale.getString(
                "Recognizer.SegmentationsPanel.Make.Tier"));
    }

    /**
     * Enable/Disable the button
     *
     * @param enabled the enable flag
     */
    public void setEnabled(boolean enabled) {
    }

    /**
     * The action performed handling; create a dialog to configure the
     * conversion.
     *
     * @param e the event
     */
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();

        if (source.equals(makeSegmentationTier)) {
            if (host.isBusy()) {
                JOptionPane.showMessageDialog(this,
                    ElanLocale.getString("SegmentsToTierDialog.Warning.Busy"),
                    ElanLocale.getString("Message.Warning"),
                    JOptionPane.WARNING_MESSAGE);

                return;
            }

            List segments = host.getSegmentations();

            if ((segments == null) || (segments.size() == 0)) {
                JOptionPane.showMessageDialog(this,
                    ElanLocale.getString(
                        "SegmentsToTierDialog.Warning.NoSegmentation"),
                    ElanLocale.getString("Message.Warning"),
                    JOptionPane.WARNING_MESSAGE);

                return;
            }

            // needs the transcription
            Command cc = ELANCommandFactory.createCommand(viewerManager.getTranscription(),
                    ELANCommandFactory.SEGMENTS_2_TIER_DLG);
            cc.execute(viewerManager.getTranscription(),
                new Object[] { segments });
        }
    }
}
