/*
 * File:     SilenceRecognizerPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.recognizer.silence;

import mpi.eudico.client.annotator.ElanLocale;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;


/**
 * 
 * @author albertr
 *
 */
public class SilenceRecognizerPanel extends JPanel implements ChangeListener {
    private JLabel minimalSilenceDurationLabel;
    private JSlider minimalSilenceDuration;
    private JLabel minimalNonSilenceDurationLabel;
    private JSlider minimalNonSilenceDuration;

    /**
 * 
 *
 */
    public SilenceRecognizerPanel() {
        int initialSilenceDuration = 400;
        int initialNonSilenceDuration = 300;

        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        add(Box.createVerticalStrut(10));
        minimalSilenceDurationLabel = new JLabel(ElanLocale.getString(
                    "Recognizer.Silence.MinimalSilenceDuration") + " " +
                initialSilenceDuration + " " +
                ElanLocale.getString("PlayAroundSelDialog.Ms"));
        add(minimalSilenceDurationLabel);
        minimalSilenceDuration = new JSlider(JSlider.HORIZONTAL, 0, 1000,
                initialSilenceDuration);
        minimalSilenceDuration.setMajorTickSpacing(200);
        minimalSilenceDuration.setMinorTickSpacing(25);
        minimalSilenceDuration.setPaintTicks(true);
        minimalSilenceDuration.setPaintLabels(true);
        minimalSilenceDuration.addChangeListener(this);
        add(minimalSilenceDuration);
        add(Box.createVerticalStrut(10));
        minimalNonSilenceDurationLabel = new JLabel(ElanLocale.getString(
                    "Recognizer.Silence.MinimalNonSilenceDuration") + " " +
                initialNonSilenceDuration + " " +
                ElanLocale.getString("PlayAroundSelDialog.Ms"));
        add(minimalNonSilenceDurationLabel);
        minimalNonSilenceDuration = new JSlider(JSlider.HORIZONTAL, 0, 1000,
                initialNonSilenceDuration);
        minimalNonSilenceDuration.setMajorTickSpacing(200);
        minimalNonSilenceDuration.setMinorTickSpacing(25);
        minimalNonSilenceDuration.setPaintTicks(true);
        minimalNonSilenceDuration.setPaintLabels(true);
        minimalNonSilenceDuration.addChangeListener(this);
        add(minimalNonSilenceDuration);
    }

    /**
     * DOCUMENT ME!
     *
     * @param e DOCUMENT ME!
     */
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider) e.getSource();
        int duration = (int) source.getValue();

        if (source == minimalSilenceDuration) {
            minimalSilenceDurationLabel.setText(ElanLocale.getString(
                    "Recognizer.Silence.MinimalSilenceDuration") + " " +
                duration + " " +
                ElanLocale.getString("PlayAroundSelDialog.Ms"));
        } else if (source == minimalNonSilenceDuration) {
            minimalNonSilenceDurationLabel.setText(ElanLocale.getString(
                    "Recognizer.Silence.MinimalNonSilenceDuration") + " " +
                duration + " " +
                ElanLocale.getString("PlayAroundSelDialog.Ms"));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMinimalSilenceDuration() {
        return minimalSilenceDuration.getValue();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMinimalNonSilenceDuration() {
        return minimalNonSilenceDuration.getValue();
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
        int duration = minimalSilenceDuration.getValue();
        minimalSilenceDurationLabel.setText(ElanLocale.getString(
                "Recognizer.Silence.MinimalSilenceDuration") + " " + duration +
            " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        duration = minimalNonSilenceDuration.getValue();
        minimalNonSilenceDurationLabel.setText(ElanLocale.getString(
                "Recognizer.Silence.MinimalNonSilenceDuration") + " " +
            duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
    }
}
