/*
 * File:     ElanConstraintEditor.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.DependentConstraint;

import mpi.search.content.query.viewer.ConstraintEditor;

import java.awt.Component;

import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;


/**
 * Font related subclass for ELAN context.
 *
 * @author HS
 * @version Aug 2008
  */
public class ElanConstraintEditor extends ConstraintEditor {
    /**
     * Creates a new ElanConstraintEditor instance
     *
     * @param treeModel
     * @param type
     * @param startAction
     */
    public ElanConstraintEditor(DefaultTreeModel treeModel, CorpusType type,
        Action startAction) {
        super(treeModel, type, startAction);
    }

    /**
     * Returns the appropriate component.
     *
     * @param tree
     * @param value
     * @param selected
     * @param expanded
     * @param leaf
     * @param row
     *
     * @return the editor component
     */
    public Component getTreeCellEditorComponent(JTree tree, Object value,
        boolean selected, boolean expanded, boolean leaf, int row) {
        if (value instanceof AnchorConstraint) {
            constraintPanel = new ElanAnchorConstraintPanel((AnchorConstraint) value,
                    treeModel, type, startAction);
        } else if (value instanceof DependentConstraint) {
            constraintPanel = new ElanDependentConstraintPanel((DependentConstraint) value,
                    treeModel, type, startAction);
        }

        return constraintPanel;
    }
}
