/*
 * File:     ElanPatternPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.viewer.PatternPanel;

import java.awt.Component;
import java.awt.Font;

import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.tree.TreeNode;


/**
 * ELAN subclass with additional font support.
 *
 * @author HS
 * @version Aug 2008
  */
public class ElanPatternPanel extends PatternPanel {
    /**
     * Creates a new ElanPatternPanel instance and applies a default
     * ELAN font to relevant ui elements.
     *
     * @param type
     * @param tierComboBox
     * @param regExCheckBox
     * @param node
     * @param startAction
     * @param prefFont
     */
    public ElanPatternPanel(CorpusType type, JComboBox tierComboBox,
        JCheckBox regExCheckBox, TreeNode node, Action startAction,
        Font prefFont) {
        super(type, tierComboBox, regExCheckBox, node, startAction);

        if (prefFont != null) {
            textField.setFont(prefFont.deriveFont(Font.BOLD, 16f));

            Component[] comps = inputPanel.getComponents();

            for (int i = 0; i < comps.length; i++) {
                if (comps[i] instanceof JComboBox) {
                    comps[i].setFont(prefFont.deriveFont(
                            comps[i].getFont().getStyle(),
                            comps[i].getFont().getSize()));
                }
            }

            tierComboBox.setFont(prefFont.deriveFont(tierComboBox.getFont()
                                                                 .getStyle(),
                    tierComboBox.getFont().getSize()));
        }
    }
}
