/*
 * File:     ElanRelationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.Constraint;

import mpi.search.content.query.viewer.RelationPanel;

import java.awt.Font;


/**
 * Subclass with extra font support.
 *
 * @author HS
 * @version Aug 2008
  */
public class ElanRelationPanel extends RelationPanel {
    /**
     * Creates a new ElanRelationPanel instance
     *
     * @param type the type
     * @param constraint the constraint
     * @param prefFont the preferred font (for some ui elements)
     */
    public ElanRelationPanel(CorpusType type, Constraint constraint,
        Font prefFont) {
        super(type, constraint);

        if (prefFont != null) {
            getUnitComboBox().setFont(prefFont.deriveFont(
                    getUnitComboBox().getFont().getStyle(),
                    getUnitComboBox().getFont().getSize()));
        }
    }
}
