/*
 * File:     ElanMatch.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.result.model;

import mpi.eudico.server.corpora.clom.Annotation;

import mpi.search.content.result.model.AbstractContentMatch;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.tree.TreeNode;


/**
 * Created on Jul 22, 2004
 * @author Alexander Klassmann
 * @version Jul 22, 2004
 */
public class ElanMatch extends AbstractContentMatch implements TreeNode {
    /** Holds value of property DOCUMENT ME! */
    final private Annotation annotation;

    /** Holds value of property DOCUMENT ME! */
    final private ElanMatch parentMatch;

    // id of constraint which this match belongs to; used to distinguish between matches of sibling constraints

    /** Holds value of property DOCUMENT ME! */
    final private String constraintId;

    /** Holds value of property DOCUMENT ME! */
    final private Vector children = new Vector();

    /**
     * Creates a new ElanMatch instance
     *
     * @param parentMatch DOCUMENT ME!
     * @param annotation DOCUMENT ME!
     * @param constraintId DOCUMENT ME!
     * @param indexWithinTier DOCUMENT ME!
     * @param substringIndices DOCUMENT ME!
     */
    public ElanMatch(ElanMatch parentMatch, Annotation annotation,
        String constraintId, int indexWithinTier, int[][] substringIndices) {
        this(parentMatch, annotation, constraintId, indexWithinTier, "", "",
            substringIndices);
    }

    /**
     * Creates a new ElanMatch instance
     *
     * @param parentMatch DOCUMENT ME!
     * @param annotation DOCUMENT ME!
     * @param constraintId DOCUMENT ME!
     * @param indexWithinTier DOCUMENT ME!
     * @param leftContext DOCUMENT ME!
     * @param rightContext DOCUMENT ME!
     * @param substringIndices DOCUMENT ME!
     */
    public ElanMatch(ElanMatch parentMatch, Annotation annotation,
        String constraintId, int indexWithinTier, String leftContext,
        String rightContext, int[][] substringIndices) {
        this.parentMatch = parentMatch;
        this.annotation = annotation;
        this.constraintId = constraintId;
        setIndex(indexWithinTier);

        setLeftContext(leftContext);
        setRightContext(rightContext);
        setMatchedSubstringIndices(substringIndices);
    }

    /**
     * DOCUMENT ME!
     *
     * @param subMatch DOCUMENT ME!
     */
    public void addChild(ElanMatch subMatch) {
        children.add(subMatch);
    }

    /**
     * DOCUMENT ME!
     *
     * @param subMatches DOCUMENT ME!
     */
    public void addChildren(Collection subMatches) {
        children.addAll(subMatches);
    }

    /**
     * DOCUMENT ME!
     *
     * @param fileName DOCUMENT ME!
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getConstraintId() {
        return constraintId;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getTierName()
     */
    public String getTierName() {
        String name = "";

        try {
            name = annotation.getTier().getName();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return name;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getValue()
     */
    public String getValue() {
        return annotation.getValue();
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getBeginTime()
     */
    public long getBeginTimeBoundary() {
        return annotation.getBeginTimeBoundary();
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getEndTime()
     */
    public long getEndTimeBoundary() {
        return annotation.getEndTimeBoundary();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Annotation getAnnotation() {
        return annotation;
    }

    /**
     * DOCUMENT ME!
     *
     * @param context DOCUMENT ME!
     */
    public void setLeftContext(String context) {
        leftContext = context;
    }

    /**
     * DOCUMENT ME!
     *
     * @param context DOCUMENT ME!
     */
    public void setRightContext(String context) {
        rightContext = context;
    }

    /**
     * DOCUMENT ME!
     *
     * @param substringIndices DOCUMENT ME!
     */
    public void setMatchedSubstringIndices(int[][] substringIndices) {
        this.matchedSubstringIndices = substringIndices;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Enumeration children() {
        return children.elements();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean getAllowsChildren() {
        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param index DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public TreeNode getChildAt(int index) {
        return (TreeNode) children.get(index);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getChildCount() {
        return children.size();
    }

    /**
     * DOCUMENT ME!
     *
     * @param node DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getIndex(TreeNode node) {
        return children.indexOf(node);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public TreeNode getParent() {
        return parentMatch;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isLeaf() {
        return children.size() == 0;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return annotation.getValue();

        /*
        StringBuffer sb = new StringBuffer();
        TreeNode loopNode = parentMatch;
        while(loopNode != null){
            sb.append("\t");
            loopNode = loopNode.getParent();
        }
        sb.append(annotation.getValue()+"\n");
        for(int i=0; i<children.size(); i++){
            sb.append(children.get(i));
        }
        return sb.toString();*/
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toHTML() {
        StringBuffer sb = new StringBuffer("<HTML><BODY>");
        TreeNode loopNode = parentMatch;

        while (loopNode != null) {
            loopNode = loopNode.getParent();
        }

        sb.append(annotation.getValue() + "<ul>");

        for (int i = 0; i < children.size(); i++) {
            sb.append(children.get(i));
        }

        sb.append("</ul>");
        sb.append("</BODY></HTML>");

        return sb.toString();
    }
}
