/*
 * File:     ContentMatch2TabDelimitedText.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.util.Transcription2TabDelimitedText;

import mpi.search.content.result.model.ContentMatch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import java.util.List;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class ContentMatch2TabDelimitedText {
    /**
     * DOCUMENT ME!
     *
     * @param matches DOCUMENT ME!
     * @param exportFile DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    static public void exportMatches(List matches, File exportFile)
        throws IOException {
        exportMatches(matches, exportFile, "UTF-8");
    }

    /**
     * Exports a List of Matches to Tab limited text (as exportAnnotations, but
     * with file name of match)
     *
     * @param matches
     * @param exportFile
     *
     * @throws IOException
     */
    static public void exportMatches(List matches, File exportFile,
        String encoding) throws IOException {
        if (exportFile == null) {
            return;
        }

        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out,
                    encoding));

        for (int i = 0; i < matches.size(); i++) {
            if (matches.get(i) instanceof ContentMatch) {
                ContentMatch match = (ContentMatch) matches.get(i);

                if (!"".equals(match.getFileName())) {
                    writer.write(match.getFileName() +
                        Transcription2TabDelimitedText.TAB);
                }

                writer.write(match.getTierName() +
                    Transcription2TabDelimitedText.getTabString(match));
            }
        }

        writer.close();
    }
}
