/*
 * File:     EAFResultViewerPopupMenu.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.export.ExportResultTableAsEAF;

import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerPopupMenu;

import java.awt.event.ActionEvent;

import javax.swing.JMenuItem;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class EAFResultViewerPopupMenu extends GridViewerPopupMenu {
    /** Holds value of property DOCUMENT ME! */
    final private JMenuItem exportAsEAFMenuItem;

    /**
     * @param table
     */
    public EAFResultViewerPopupMenu(AnnotationTable table) {
        super(table);

        exportAsEAFMenuItem = new JMenuItem(ElanLocale.getString(
                    "Frame.GridFrame.ExportTableAsEAF"));
        exportAsEAFMenuItem.addActionListener(this);
    }

    /**
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == exportAsEAFMenuItem) {
            // export results as eaf
            ExportResultTableAsEAF exporter = new ExportResultTableAsEAF();
            exporter.exportTableAsEAF(table);
        } else {
            super.actionPerformed(e);
        }
    }

    /**
     * Calls super.makeLayout and adds an additional item, export with context as eaf.
     */
    protected void makeLayout() {
        super.makeLayout();
        add(exportAsEAFMenuItem);
    }
}
