/*
 * File:     EAFMultipleFileSearchFrame.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.viewer;

import mpi.eudico.client.annotator.ElanFrame2;

import mpi.eudico.client.annotator.gui.ClosableFrame;

import mpi.search.SearchLocale;

import javax.swing.ImageIcon;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class EAFMultipleFileSearchFrame extends ClosableFrame {
    /** Holds value of property DOCUMENT ME! */
    EAFMultipleFileSearchPanel searchPanel;

    /**
     * Creates a new EAFMultipleFileSearchFrame instance
     *
     * @param elanFrame DOCUMENT ME!
     */
    public EAFMultipleFileSearchFrame(ElanFrame2 elanFrame) {
        super(SearchLocale.getString("MultipleFileSearch.Title"));

        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));

        if (icon != null) {
            setIconImage(icon.getImage());
        } else {
            setIconImage(null);
        }

        searchPanel = new EAFMultipleFileSearchPanel(elanFrame);
        getContentPane().add(searchPanel);
        pack();
    }

    // moet vanuit Elan worden aangeroepen
    // GEEN NIEUWE ELANS creeeren vanuit result list maar alles binnen de
    // huidige runtime houden
    static public void main(String[] args) {
        new EAFMultipleFileSearchFrame(null);
    }
}
