/*
 * File:     ElanSearchFrame.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.eudico.client.annotator.search.viewer;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.EscCloseAction;

import mpi.search.SearchLocale;

import mpi.search.content.viewer.AbstractComplexSearchFrame;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;


/**
 * $Id: ElanSearchFrame.java 8263 2007-02-27 10:25:01Z hasloe $
 *
 * @author $Author$
 * @version $Revision$
 * @version Aug 2005 Identity removed
 */
public class ElanSearchFrame extends AbstractComplexSearchFrame {
    /**
     * Creates a new ElanSearchFrame object.
     *
     * @param viewerManager DOCUMENT ME!
     */
    public ElanSearchFrame(ViewerManager2 viewerManager) {
        super(new ElanSearchPanel(viewerManager));

        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));

        if (icon != null) {
            setIconImage(icon.getImage());
        } else {
            setIconImage(null);
        }

        JMenu editMenu = new JMenu(SearchLocale.getString("SearchDialog.Edit"));
        editMenu.add(ELANCommandFactory.getUndoCA(
                viewerManager.getTranscription()));
        editMenu.add(ELANCommandFactory.getRedoCA(
                viewerManager.getTranscription()));
        editMenu.addSeparator();
        editMenu.add(((ElanSearchPanel) searchPanel).replaceAction);
        ((ElanSearchPanel) searchPanel).replaceAction.setEnabled(false);
        getJMenuBar().add(editMenu, 1);

        pack();
        setSize(640, 600);
        validate();

        // ensure that the panel is disconnected from the viewer manager and is no longer registered 
        // as ACMEditListener
        this.addWindowListener(new WindowAdapter() {
                public void windowClosed(WindowEvent we) {
                    ((ElanSearchPanel) ElanSearchFrame.this.searchPanel).close();
                }
            });

        addCloseActions();

        setVisible(true);
    }

    /**
     * Add the Escape and Ctrl-W close actions.
     */
    protected void addCloseActions() {
        EscCloseAction escAction = new EscCloseAction(this);
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);

        InputMap inputMap = getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
        ActionMap actionMap = getRootPane().getActionMap();

        if (inputMap instanceof ComponentInputMap && (actionMap != null)) {
            String esc = "esc";
            inputMap.put((KeyStroke) escAction.getValue(Action.ACCELERATOR_KEY),
                esc);
            actionMap.put(esc, escAction);

            String wcl = "cw";
            inputMap.put((KeyStroke) wAction.getValue(Action.ACCELERATOR_KEY),
                wcl);
            actionMap.put(wcl, wAction);
        }
    }
}
