/*
 * File:     SVGPrefs.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.svg;


/**
 * A class to store some graphical annotations related preferences.
 *
 * @author Han Sloetjes
 * @version 1.0 may-2004
 */
public class SVGPrefs {
    private static boolean useSVG = false;

    /**
     * Enables or disables the use of graphical annotations (SVG).
     *
     * @param enable if true the use of SVG is enabled
     */
    public static void setUseSVG(boolean enable) {
        useSVG = enable;
    }

    /**
     * True if the use of graphical annotations is enabled.
     *
     * @return true if the use of graphical annotations is enabled, false
     *         otherwise
     */
    public static boolean getUseSVG() {
        return useSVG;
    }
}
