/*
 * File:     MergeTiersStep2.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.tier;

import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


/**
 * Second step of this wizard: entering of a  name for the new tier, selection
 * of it's linguistic type and optional selection of the format of the
 * duration  as annotation values. The new annotations can also be a concatenation
 * of merged annotation values.
 *
 * @author Han Sloetjes
 * @version 1.0 July 2008
 */
public class MergeTiersStep2 extends CalcOverlapsStep2
    implements ListSelectionListener, ActionListener, CaretListener {
    private JRadioButton concatValuesRB;
    private JRadioButton durationRB;
    private ButtonGroup contentBG;

    /**
 * Constructor
 *
 * @param multiPane the container pane
 * @param transcription the transcription
 */
    public MergeTiersStep2(MultiStepPane multiPane,
        TranscriptionImpl transcription) {
        super(multiPane, transcription);

        //initComponents();
    }

    /**
 * Adds a textfield for a new tiername, a list of valid linguistic types
 * and a checkbox  denoting whether or not the overlap duration should be
 * the annotation value.
 *
 * @see mpi.eudico.client.annotator.gui.multistep.StepPane#initComponents()
 */
    protected void initComponents() {
        super.initComponents();

        /*
        nameLabel = new JLabel(ElanLocale.getString(
                    "OverlapsDialog.Label.DestName"));
        typeLabel = new JLabel(ElanLocale.getString(
                    "OverlapsDialog.Label.Type"));
                    */
        contentBG = new ButtonGroup();
        concatValuesRB = new JRadioButton(ElanLocale.getString(
                    "OverlapsDialog.Label.Content2"));
        concatValuesRB.setSelected(true);
        concatValuesRB.addActionListener(this);
        contentBG.add(concatValuesRB);
        durationRB = new JRadioButton(ElanLocale.getString(
                    "OverlapsDialog.Label.Content"));
        durationRB.addActionListener(this);
        contentBG.add(durationRB);

        GridBagConstraints gbc = ((GridBagLayout) getLayout()).getConstraints(contentCB);
        remove(contentCB);
        contentCB.setSelected(false);
        add(durationRB, gbc);
        msRB.setEnabled(false);
        secRB.setEnabled(false);
        hourRB.setEnabled(false);

        gbc = ((GridBagLayout) getLayout()).getConstraints(hourRB);
        gbc.gridy++;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        add(concatValuesRB, gbc);
    }

    /**
 * @see mpi.eudico.client.annotator.gui.multistep.Step#getStepTitle()
 */
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.DefineDest");
    }

    /**
 * Check and store properties, if all conditions are met.
 *
 * @see mpi.eudico.client.annotator.gui.multistep.Step#leaveStepForward()
 */
    public boolean leaveStepForward() {
        if (super.leaveStepForward()) {
            if (durationRB.isSelected()) {
                multiPane.putStepProperty("ContentType", "Duration");

                if (msRB.isSelected()) {
                    multiPane.putStepProperty("Format",
                        new Integer(Constants.MS));
                } else if (secRB.isSelected()) {
                    multiPane.putStepProperty("Format",
                        new Integer(Constants.SSMS));
                } else if (hourRB.isSelected()) {
                    multiPane.putStepProperty("Format",
                        new Integer(Constants.HHMMSSMS));
                }
            } else {
                multiPane.putStepProperty("ContentType", "Concatenation");
            }

            return true;
        }

        return false;
    }

    /**
 * Receives events from the textfield and the content checkbox.
 *
 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
 */
    public void actionPerformed(ActionEvent e) {
        if ((e.getSource() == durationRB) || (e.getSource() == concatValuesRB)) {
            msRB.setEnabled(durationRB.isSelected());
            secRB.setEnabled(durationRB.isSelected());
            hourRB.setEnabled(durationRB.isSelected());
        }

        if ((e.getSource() == matchedValuesCB) ||
                (e.getSource() == specificValueCB)) {
            super.actionPerformed(e);
        } else {
            checkConditions();
        }
    }
}
