/*
 * File:     TimeSeriesConstants.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries;


/**
 * @author Han Sloetjes
 */
public interface TimeSeriesConstants {
    /** Holds value of property DOCUMENT ME! */
    public static final String FIXED_RATE = "Fixed rate";

    /** Holds value of property DOCUMENT ME! */
    public static final String VARIABLE_RATE = "Variable rate";

    /** Holds value of property DOCUMENT ME! */
    public static final String UNKNOWN_RATE_TYPE = "Unknown";

    /** Holds value of property DOCUMENT ME! */
    public static final String DISCONTINUOUS_RATE = "Discontinuous Rate";

    /** Holds value of property DOCUMENT ME! */
    public static final String CONTINUOUS_RATE = "Continuous Rate";

    // keys for storage of properties

    /** Holds value of property DOCUMENT ME! */
    public static final String AUTO_DETECT_RANGE = "detect-range";

    /** Holds value of property DOCUMENT ME! */
    public static final String SAMPLE_POS = "pos";

    // configuration xml strings

    /** file suffix */
    public static final String CONF_SUFFIX = "_tsconf.xml";

    /** Holds value of property DOCUMENT ME! */
    public static final String TIMESERIES = "timeseries";

    /** Holds value of property DOCUMENT ME! */
    public static final String DATE = "date";

    /** Holds value of property DOCUMENT ME! */
    public static final String VERS = "version";

    /** Holds value of property DOCUMENT ME! */
    public static final String SOURCE = "tracksource";

    /** Holds value of property DOCUMENT ME! */
    public static final String URL = "source-url";

    /** Holds value of property DOCUMENT ME! */
    public static final String ORIGIN = "time-origin";

    /** Holds value of property DOCUMENT ME! */
    public static final String TIME_COLUMN = "time-column";

    /** Holds value of property DOCUMENT ME! */
    public static final String SAMPLE_TYPE = "sample-type";

    /** Holds value of property DOCUMENT ME! */
    public static final String PROVIDER = "provider";

    /** Holds value of property DOCUMENT ME! */
    public static final String PROP = "property";

    /** Holds value of property DOCUMENT ME! */
    public static final String KEY = "key";

    /** Holds value of property DOCUMENT ME! */
    public static final String VALUE = "value";

    /** Holds value of property DOCUMENT ME! */
    public static final String TRACK = "track";

    /** Holds value of property DOCUMENT ME! */
    public static final String NAME = "name";

    /** Holds value of property DOCUMENT ME! */
    public static final String DERIVATION = "derivative";

    /** Holds value of property DOCUMENT ME! */
    public static final String DESC = "description";

    /** Holds value of property DOCUMENT ME! */
    public static final String UNITS = "units";

    /** Holds value of property DOCUMENT ME! */
    public static final String POSITION = "sample-position";

    /** Holds value of property DOCUMENT ME! */
    public static final String ROW = "row";

    /** Holds value of property DOCUMENT ME! */
    public static final String COL = "col";

    /** Holds value of property DOCUMENT ME! */
    public static final String RANGE = "range";

    /** Holds value of property DOCUMENT ME! */
    public static final String MIN = "min";

    /** Holds value of property DOCUMENT ME! */
    public static final String MAX = "max";

    /** Holds value of property DOCUMENT ME! */
    public static final String DATA_TYPE = "data-type";

    /** Holds value of property DOCUMENT ME! */
    public static final String COLOR = "color";
}
