/*
 * File:     TimeValue.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries;


/**
 * A class containing a field for a time in ms (long) and a field for an amplitude value (float).
 * The fields are public, no getters and setters provided.<br>
 * When there is a number of TimeValue objects in a non-continuous rate track, a line will be drawn between
 * two subsequent time-value points.
 * The class implements Comparable; the compareTo method compares the time of the objects.
 */
public class TimeValue implements Comparable {
    /** Holds value of property DOCUMENT ME! */
    public long time;

    /** Holds value of property DOCUMENT ME! */
    public float value;

    /**
     * No arg constructor, fields are initialised to their default value, 0;
     */
    public TimeValue() {
        time = 0L;
        value = 0f;
    }

    /**
     * Constructor, sets the fields to the value of the arguments.
     * @param time the time
     * @param value the value or amplitude
     */
    public TimeValue(long time, float value) {
        this.time = time;
        this.value = value;
    }

    /**
     * Returns -1 if this object's time is less than the other object's time, 0 if the times are
     * equal, 1 if this object's time is greater than the object's time.
     * @param o the TimeValue object to compare with
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(Object o) {
        if (!(o instanceof TimeValue)) {
            throw new ClassCastException("The object is not a TimeValue object");
        }

        if (((TimeValue) o).time > this.time) {
            return -1;
        } else if (((TimeValue) o).time < this.time) {
            return 1;
        }

        return 0;
    }
}
