/*
 * File:     TSServiceProvider.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries.spi;

import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;


/**
 * Defines the methods a time series ServiceProvider should implement.
 *
 * @author Han Sloetjes
 */
public interface TSServiceProvider {
    /**
     * The provider can check the source and report whether or not it can
     * handle it.
     *
     * @param filePath the location of the source
     *
     * @return true if the source is compatible with this provider
     */
    public boolean canHandle(String filePath);

    /**
     * Returns whether or not this provider can create a ui for selection and
     * configuration of tracks. If not getConfigPanel should return null and
     * autoCreateTracks should add the track(s) from the source to config.
     *
     * @return true if there is anything to configure (requires ui), false
     *         otherwise
     */
    public boolean isConfigurable();

    /**
     * A ui component enabling the user to select and configure tracks.
     *
     * @param config the config object for the source
     *
     * @return a JComponent that can be added to a dialog/frame
     */
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config);

    /**
     * Creates tracks from the source without any user interaction.
     *
     * @param config the config object for the source
     */
    public void autoCreateTracks(TSSourceConfiguration config);

    /**
     * Creates track using the track information contained in the
     * configuration object.
     *
     * @param config the config object for the source
     */
    public void createTracksFromConfiguration(TSSourceConfiguration config);
}
