/*
 * File:     AnnotationValuesRecord.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import mpi.eudico.server.corpora.clom.Annotation;


/**
 * An AnnotationDataRecord extended with a field + getter and setter for
 * the new value. Used for undo/redo.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class AnnotationValuesRecord extends AnnotationDataRecord {
    private String newLabelValue;

    /**
 * Construcor.
 *
 * @param annotation the annotation
 */
    public AnnotationValuesRecord(Annotation annotation) {
        super(annotation);
    }

    /**
 * @param tierName tier name
 * @param value the annotation value
 * @param beginTime the begin time 
 * @param endTime the end time
 */
    public AnnotationValuesRecord(String tierName, String value,
        long beginTime, long endTime) {
        super(tierName, value, beginTime, endTime);
    }

    /**
 * Returns the new label or value of the annotation
 *
 * @return the new label or value of the annotation
 */
    public String getNewLabelValue() {
        return newLabelValue;
    }

    /**
 * Sets the new label or value of the annotation
 *
 * @param newLabelValue the new value
 */
    public void setNewLabelValue(String newLabelValue) {
        this.newLabelValue = newLabelValue;
    }
}
