/*
 * File:     LocaleDiff.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import java.io.File;
import java.io.FileWriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class LocaleDiff {
    /**
     * Creates a new LocaleDiff instance
     */
    public LocaleDiff() {
    }

    /**
     * DOCUMENT ME!
     */
    public void run() {
        ResourceBundle english = ResourceBundle.getBundle(
            //"mpi.search.resources.SearchLanguage", new Locale("", "", ""));
            "mpi.eudico.client.annotator.resources.ElanLanguage",
                new Locale("", "", ""));

        Locale loc = null;
        PropertyResourceBundle other = null;
        Enumeration engEn = null;
        Collection allLocs = ELANCommandFactory.getLocales();
        Iterator locIt = allLocs.iterator();

        while (locIt.hasNext()) {
            loc = (Locale) locIt.next();

            if (loc.equals(Locale.ENGLISH)) {
                continue;
            }

            try {
                other = (PropertyResourceBundle) ResourceBundle.getBundle(
                    //"mpi.search.resources.SearchLanguage", loc);
                    "mpi.eudico.client.annotator.resources.ElanLanguage", loc);
            } catch (Exception ee) {
                System.out.println("Could not load resource: " +
                    ee.getMessage());

                continue;
            }

            engEn = english.getKeys();

            String key;

            ArrayList list = new ArrayList();

            while (engEn.hasMoreElements()) {
                key = (String) engEn.nextElement();

                // filter out mnemonics
                try {
                    Integer.valueOf(english.getString(key));

                    continue;
                } catch (NumberFormatException nfe) {
                    // do nothing, ok
                }

                if (other.handleGetObject(key) == null) {
                    list.add((key + "=" + english.getString(key)));
                }
            }

            Collections.sort(list);
            writeProperties(loc, list);

            //writeProperties(loc, buf);
        }
    }

    private void writeProperties(Locale loc, StringBuffer props) {
        try {
            //File f = new File(System.getProperty("user.home") + File.separator + "SearchDiff_" +
            File f = new File(System.getProperty("user.home") + File.separator +
                    "LangDiff_" + loc.getLanguage() + ".properties");
            FileWriter writer = new FileWriter(f);
            writer.write(props.toString());
            writer.close();
        } catch (Exception e) {
            System.out.println("Could not write file: " + e.getMessage());
        }
    }

    private void writeProperties(Locale loc, ArrayList props) {
        try {
            //File f = new File(System.getProperty("user.home") + File.separator + "SearchDiff_" +
            File f = new File(System.getProperty("user.home") + File.separator +
                    "LangDiff_" + loc.getLanguage() + ".properties");
            FileWriter writer = new FileWriter(f);

            for (int i = 0; i < props.size(); i++) {
                writer.write((String) props.get(i) + "\n");
            }

            writer.close();
        } catch (Exception e) {
            System.out.println("Could not write file: " + e.getMessage());
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param args DOCUMENT ME!
     */
    public static void main(String[] args) {
        new LocaleDiff().run();
    }
}
