/*
 * File:     SystemReporting.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import mpi.util.LogUtil;

import java.awt.RenderingHints;
import java.awt.Toolkit;

import java.io.File;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class SystemReporting {
    /** Holds value of property DOCUMENT ME! */
    public static final String OS_NAME;

    /** Holds value of property DOCUMENT ME! */
    public static final String USER_HOME;

    /** Holds value of property DOCUMENT ME! */
    public static boolean antiAliasedText = false;
    private static boolean isMacOS;
    private static boolean isWindows;
    private static boolean isLinux;

    /** Holds value of property DOCUMENT ME! */
    private static final Logger LOG = Logger.getLogger(SystemReporting.class.getName());

    static {
        OS_NAME = System.getProperty("os.name");
        USER_HOME = System.getProperty("user.home");

        String lowerOS = OS_NAME.toLowerCase();

        if (lowerOS.indexOf("win") > -1) {
            isWindows = true;
        } else if (lowerOS.indexOf("mac") > -1) {
            isMacOS = true;
        } else if (lowerOS.indexOf("lin") > -1) {
            isLinux = true;
        }

        String atp = System.getProperty("swing.aatext");

        if ("true".equals(atp)) {
            antiAliasedText = true;
        }

        // for now under J 1.6 only apply the text anti aliasing property
        Map map = (Map) (Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints"));

        if (map != null) {
            Object aaHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);

            if (RenderingHints.VALUE_TEXT_ANTIALIAS_OFF != aaHint /*||
                RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT.equals(aaHint)*/    ) {
                // treat default as anti-aliasing on??
                antiAliasedText = true;
            }

            //Iterator mapIt = map.keySet().iterator();
        }

        String awtRH = System.getProperty("awt.useSystemAAFontSettings");

        if ("on".equals(awtRH)) {
            antiAliasedText = true;
        } else if (map != null) {
            // a desktop setting is overriden by a -D argument
            // should do more specialized testing on the value of awtRH
            if ("off".equals(awtRH) || "false".equals(awtRH) ||
                    "default".equals(awtRH)) {
                antiAliasedText = false;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static boolean isMacOS() {
        return isMacOS;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static boolean isWindows() {
        return isWindows;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static boolean isLinux() {
        return isLinux;
    }

    /**
     * DOCUMENT ME!
     *
     * @param prop DOCUMENT ME!
     */
    public static void printProperty(String prop) {
        System.out.println(prop + " = " + System.getProperty(prop));
    }

    /**
     *  @return lib/ext directory.
     */
    public static File getLibExtDir() {
        if (OS_NAME.startsWith("Mac OS X")) {
            // HS 04-2007 use a BufferedImage in TimeLineViewer on Mac by default
            String useBI = System.getProperty("useBufferedImage");

            if (useBI == null) {
                System.setProperty("useBufferedImage", "true");
            }

            return verifyMacUserLibExt();
        } else {
            return new File(System.getProperty("java.home") + File.separator +
                "lib" + File.separator + "ext");
        }
    }

    /**
       @return files from lib/ext. May be null.
    */
    public static File[] getLibExt() {
        File ext = SystemReporting.getLibExtDir();

        if ((ext != null) && ext.exists()) {
            return SystemReporting.getLibExtDir().listFiles();
        } else {
            return null;
        }
    }

    private static File verifyMacUserLibExt() {
        // im jars will be stored in the user home library ext dir
        String userLibJavaExt = USER_HOME + "/Library/Java/Extensions";

        File userLibExt = new File(userLibJavaExt);

        //System.out.println("Home lib ext: " + userLibJavaExt);
        if (!userLibExt.exists()) {
            try {
                boolean success = userLibExt.mkdirs();

                if (!success) {
                    LOG.warning("Unable to create folder: " + userLibExt);

                    return null;
                }
            } catch (SecurityException se) {
                LOG.warning("Unable to create folder: " + userLibExt);
                LOG.warning(LogUtil.formatStackTrace(se));

                return null;
            }
        }

        return userLibExt;
    }

    /**
       report files from lib/ext
    */
    public static void printLibExt() {
        File[] potext = getLibExt();
        int NOFfiles = (potext == null) ? 0 : potext.length;
        System.out.println("Found " + NOFfiles + " potential extension(s)");

        for (int i = 0; i < NOFfiles; i++) {
            System.out.println("\t" + potext[i]);
        }
    }

    /**
       testing
     */
    public static void main(String[] args) throws Exception {
        printProperty("java.home");
        printLibExt();
    }
}
