/*
 * File:     MacApplicationListener.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.mac;


/**
 * Defines Mac OS X specific methods for handling the main screen menu
 * Application events.
 *
 * @version Feb 2009 added delegate methods for all methods in com.apple.eawt.ApplicationListener
 */
public interface MacApplicationListener {
    /**
     * Handle the standard main/screen menu bar Quit action.
     */
    public void macHandleQuit();

    /**
     * Handle the standard main/screen menu bar About action.
     *
     */
    public void macHandleAbout();

    /**
     * Handle the standard main/screen menu bar Preferences action.
     *
     */
    public void macHandlePreferences();

    /**
     * Any initialization on application launch. If a file path is specified then
     * open it.
     *
     * @param fileName the path to a file, or null
     */
    public void macHandleOpenApplication(String fileName);

    /**
     * Open the specified file.
     *
     * @param fileName the path to a file
     */
    public void macHandleOpenFile(String fileName);

    /**
     * Request to print a file. Could be a print with default settings?
     * Or show a preview window?
     *
     * @param fileName the path to a file
     */
    public void macHandlePrintFile(String fileName);

    /**
     * Any initialization on application (re)launch. If a file path is specified then
     * open it.
     *
     * @param fileName the path to a file, or null
     */
    public void macHandleReOpenApplication(String fileName);
}
