/*
 * File:     LinkButton.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;

import java.awt.event.ActionEvent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;


/**
 * Functions like a JButton, but looks like a link in a HTML-page
 * Created on Oct 26, 2004
 * @author Alexander Klassmann
 * @version Oct 26, 2004
 */
public class LinkButton extends JEditorPane {
    private String actionName;
    private boolean enabled = true;

    /**
     * Creates a new LinkButton instance
     *
     * @param action DOCUMENT ME!
     */
    public LinkButton(final Action action) {
        setContentType("text/html");
        setEditable(false);
        actionName = (String) action.getValue(Action.NAME);

        addHyperlinkListener(new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (enabled) {
                            action.actionPerformed(new ActionEvent(this, 0,
                                    e.getDescription()));
                        }
                    }
                }
            });

        action.addPropertyChangeListener(new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent e) {
                    if ("enabled".equals(e.getPropertyName())) {
                        setEnabled(action.isEnabled());
                    }
                }
            });

        setToolTipText((String) action.getValue(Action.SHORT_DESCRIPTION));
        reset();
    }

    /**
     * DOCUMENT ME!
     *
     * @param label DOCUMENT ME!
     */
    public void setLabel(String label) {
        actionName = (label != null) ? label : "";
        reset();
    }

    /**
     * DOCUMENT ME!
     *
     * @param enabled DOCUMENT ME!
     */
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            reset();
        }
    }

    private void reset() {
        if (enabled) {
            setText("<A HREF=\"" + actionName + "\"><font size=\"3\">" +
                actionName + "</font></A>");
        } else {
            setText("<font size=\"3\">" + actionName + "</font>");
        }
    }

    //	public Dimension getPreferredSize() {
    //		return new Dimension(super.getPreferredSize().width, super.getPreferredSize().height - 2);
    //	}
}
