/*
 * File:     MutableInt.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;


/**
 * An int wrapper, a mutable variant of Integer.
 * 
 * @author Han Sloetjes
 */
public class MutableInt {
    /** public access to avoid getter and setter */
    public int intValue;

    /**
 * Constructor.
 */
    public MutableInt() {
        super();
        intValue = 0;
    }

    /**
 * Constructor.
 * 
 * @param intValue the new value
 */
    public MutableInt(int intValue) {
        super();
        this.intValue = intValue;
    }
}
