/*
 * File:     TableHeaderToolTipAdapter.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;


/**
 * A mouse motion listener that sets the tooltip to the value of the table
 * header.
 * 
 * @author Han Sloetjes
 */
public class TableHeaderToolTipAdapter extends MouseMotionAdapter {
    private JTableHeader header;

    /**
 * Constructor.
 * 
 * @param header
 *            the table header
 */
    public TableHeaderToolTipAdapter(JTableHeader header) {
        super();
        this.header = header;
    }

    /**
 * Sets the tooltip to the value of the column header at the mouse location.
 * 
 * @see java.awt.event.MouseMotionAdapter#mouseMoved(java.awt.event.MouseEvent)
 */
    public void mouseMoved(MouseEvent e) {
        if (header != null) {
            int colIndex = header.columnAtPoint(e.getPoint());

            if (colIndex > -1) {
                TableColumn col = header.getColumnModel().getColumn(colIndex);

                if ((col != null) && (col.getHeaderValue() != null)) {
                    header.setToolTipText(col.getHeaderValue().toString());
                }
            }
        }
    }
}
