/*
 * File:     Annotation.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.event.ParentAnnotationListener;

import mpi.eudico.server.corpora.util.ACMEditableObject;

import java.util.Vector;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 16145 2009-08-24 11:55:06Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public interface Annotation extends AnnotationCore, Comparable, ACMEditableObject,
    ParentAnnotationListener, ParentAnnotation {
    /**
     * DOCUMENT ME!
     *
     * @param theValue DOCUMENT ME!
     */
    public void setValue(String theValue);

    /**
     * DOCUMENT ME!
     *
     * @param theValue DOCUMENT ME!
     */
    public void updateValue(String theValue);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Tier getTier();

    /**
     * DOCUMENT ME!
     *
     * @param deleted DOCUMENT ME!
     */
    public void markDeleted(boolean deleted);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isMarkedDeleted();

    /**
     * DOCUMENT ME!
     *
     * @param tier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getChildrenOnTier(Tier tier);

    /**
    * Checks if this Annotation has a parent Annotation.
    */
    public boolean hasParentAnnotation();

    /**
     * Returns this Annotation's parent Annotation.
     */
    public Annotation getParentAnnotation();

    /**
     * Returns the id of the annotation
     * @return
     */
    public String getId();

    /**
     * Sets the id of the annotation
     * @param s
     */
    public void setId(String s);
}
