/*
 * File:     DataTreeNode.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;


/**
 * DataTreeNode is implemented to administer the hierarchical structure of
 * Corpus data objects in the EUDICO hierarchical database. Knowledge about
 * this structure is needed for several purposes, for example, to be able to
 * delete a child of a specific node, or to pass on requests for information
 * to objects higher in the hierarchy.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 25-May-1998
 */
public interface DataTreeNode {
    /**
     * Gives the parent of this node in the Corpus data object hierarchy.
     *
     * @return the parent DataTreeNode
     */
    public DataTreeNode getParent();

    /**
     * Removes a child in the Corpus data hierarchy by deleting it's reference
     * to that child. The garbage collector will then actually delete the
     * child object.
     *
     * @param theChild the child node to be deleted
     */
    public void removeChild(DataTreeNode theChild);
}
