/*
 * File:     ExternalReference.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;


/**
 * Defines an obejct for external referenences to e.g. concepts or resources.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public interface ExternalReference extends Cloneable {
    /** the undefined type reference constant */
    public static final int UNDEFINED = 0;

    /** a constant for a group of references */
    public static final int REFERENCE_GROUP = 1;

    /**
     * a constant for a reference to (the id of) a concept defined in the ISO
     * 12620 DCR
     */
    public static final int ISO12620_DC_ID = 2;

    /**
     * a constant to an external resource identified by a url or uri. The exact
     * type of the resource is not defined
     */
    public static final int RESOURCE_URL = 3;

    /**
     * Returns the type of reference, e.g. url to a resource, id of concept in
     * DCR or ontology.
     *
     * @return the reference type
     */
    public int getReferenceType();

    /**
     * Sets the type of this reference object, e.g. a resource (url) or a
     * concept (id)
     *
     * @param refType the type of the reference
     */
    public void setReferenceType(int refType);

    /**
     * Returns the value of the reference. It depends on the type of the
     * reference how the  value should be interpreted.
     *
     * @return the reference value
     */
    public String getValue();

    /**
     * Sets the value of the reference, a url or an id depending on the type of
     * reference.
     *
     * @param value the value of the reference
     */
    public void setValue(String value);

    /**
     * Returns a string representation of the external reference object.
     *
     * @return a string representation of the external reference object
     */
    public String paramString();

    /**
     * Creates and returns a copy of this instance.
     *
     * @return a copy of this instance
     *
     * @throws CloneNotSupportedException
     */
    public Object clone() throws CloneNotSupportedException;
}
