/*
 * File:     LanguageResource.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;

import java.io.InputStream;


/**
 * interface LanguageResource
 * models raw data resource such as a transcript, media file, label file etc.
 * @version Aug 2005 Identity and IdentityManager removed
 */
public interface LanguageResource extends TreeViewable {
    // for the moment empty
    // public void setFormat(String fmt);
    // public String getFormat();

    /**
     * get the URL specification of the content
     * return null if not available
     */
    public String getFullPath();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getContentType();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public InputStream getContentStream();
}
