/*
 * File:     Property.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;


/**
 * Defines that a property that has a name and a value.
 *
 * @author Han Sloetjes, MPI
 */
public interface Property {
    /**
     * Returns the name of the property.
     *
     * @return the name of the property, can be <code>null</code>
     */
    public String getName();

    /**
     * Sets the name of the property.
     *
     * @param name the name of the property
     */
    public void setName(String name);

    /**
     * Returns the value of the property.
     *
     * @return the value of the property, can be <code>null</code>
     */
    public Object getValue();

    /**
     * Sets the value of the property, typically a String.
     *
     * @param value the value of the property
     */
    public void setValue(Object value);
}
