/*
 * File:     TierUnsharedInfo.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.event.NotImplementedException;


/**
 * TierUnsharedInfo consists of attributes that are unique the Tier's
 * Transcription. Some of this interface's methods can not be implemented by
 * all Corpora and will throw a NotImplementedException.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 26-May-1998
 * @version Aug 2005 Identity removed
 */
public interface TierUnsharedInfo {
    /**
     * Gives the name of the person who has transcribed this Tier.
     *
     *
     * @return the Transcriber's name
     *
     * @exception NotImplementedException is thrown when a specific
     *            implementation     class is not able to return a Transcriber
     */
    public String getTranscriber() throws NotImplementedException;

    /**
     * Returns a string describing the exactness of time alignment of the
     * Tier's Tags. Is probably only implemented by a limited number of
     * Corpora.
     *
     * @return the quality of the tier's Tag alignment
     *
     * @exception NotImplementedException thrown when a specific implementation
     *            class is not able to determine a quality
     */
    public String getQuality() throws NotImplementedException;
}
