/*
 * File:     TimeSlot.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;


/**
 * DOCUMENT ME!
 * $Id: TimeSlot.java 2 2004-03-25 16:22:33Z wouthuij $
 * @author $Author$
 * @version $Revision$
 */
public interface TimeSlot extends Comparable {
    /** Holds value of property DOCUMENT ME! */
    public static final int TIME_UNALIGNED = -1;

    /** Holds value of property DOCUMENT ME! */
    public static final int NOT_INDEXED = -1;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getIndex();

    /**
     * DOCUMENT ME!
     *
     * @param theIndex DOCUMENT ME!
     */
    public void setIndex(int theIndex);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getTime();

    /**
     * DOCUMENT ME!
     *
     * @param theTime DOCUMENT ME!
     */
    public void setTime(long theTime);

    /**
     * Only to be called by TimeOrder !!
     */
    public void updateTime(long theTime);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isTimeAligned();

    /**
     * DOCUMENT ME!
     *
     * @param timeSlot DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isAfter(TimeSlot timeSlot);
}
