/*
 * File:     DefaultDataLocator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomdefault;

import mpi.eudico.server.corpora.location.DataLocator;
import mpi.eudico.server.corpora.location.DirectoryTree;


/**
   <p>MK:02/06/10<br>
    DataLocator is used in DataManager is used in Corpus is used in CorpusManager.
    CHAT uses the same puppet-chain, and also wraps a DirectoryTree.
    DirectoryTree was a generic class and than geared to CHAT format.<br>
    There is no such puppet-chain for DOBES.
    DataLocator is an empty class.
   </p>

  */
public class DefaultDataLocator extends DataLocator
    implements java.io.Serializable {
    /**
     * The base locator of (the top level of?) a Default corpus
     */
    private DirectoryTree tree;

    /**
     * Creates a new DefaultDataLocator instance
     *
     * @param tree DOCUMENT ME!
     */
    public DefaultDataLocator(DirectoryTree tree) {
        this.tree = tree;
    }

    /**
       Returns a reference to base locator
     */
    final public DirectoryTree getDirectoryTree() {
        return this.tree;
    }
}
