/*
 * File:     LanguageResourceImpl.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.LanguageResource;

import java.io.InputStream;


/**
 * LanguageResourceImpl implements generic part of Language Resources
 *
 * @author Daan Broeder
 * @version 27-Sept-2000
 * @version Aug 2005 Identity removed
 */
public abstract class LanguageResourceImpl implements LanguageResource {
    /**
     * mime_type: classification of the resource data to enable tools to
     * recognise it
     */
    protected String mime_type = "";

    /**
     * Creates a new LanguageResourceImpl instance
     */
    LanguageResourceImpl() {
    }

    /**
     * set the mime_type for the LR content data
     *
     * @param s DOCUMENT ME!
     */
    public void setContentType(String s) {
        mime_type = s;
    }

    /**
     * return the associated mime_type of the LR content
     *
     * @return DOCUMENT ME!
     */
    public String getContentType() {
        return mime_type;
    }

    /**
     * return the LR content in the for of an InputStream
     *
     * @return DOCUMENT ME!
     */
    public InputStream getContentStream() {
        return null;
    }

    /**
     * getFullPath() get the localistation specification of the content data
     * return null if not available
     *
     * @return DOCUMENT ME!
     */
    public String getFullPath() {
        //default implementation
        return null;
    }
}


//LanguageResourceImpl
