/*
 * File:     PropertyImpl.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.Property;


/**
 * Simple implementation of a property class.
 * This class stores a property that <strong>can</strong> have a name
 * and <strong>can</strong> have a value,.
 *
 * @author Han Sloetjes, MPI
 */
public class PropertyImpl implements Property {
    private String name;
    private Object value;

    /**
     * @see mpi.eudico.server.corpora.clom.Property#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see mpi.eudico.server.corpora.clom.Property#setName(java.lang.String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @see mpi.eudico.server.corpora.clom.Property#getValue()
     */
    public Object getValue() {
        return value;
    }

    /**
     * @see mpi.eudico.server.corpora.clom.Property#setValue(java.lang.Object)
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * Returns the name and value separated by a colon if both are not null. If
     * name is null value.toString is returned, if value is null the name is
     * returned. If both are null an empty String is returned.
     *
     * @return a string representation of the property
     */
    public String toString() {
        if (name == null) {
            if (value == null) {
                return "";
            } else {
                return value.toString();
            }
        } else if (value == null) {
            return name;
        }

        return name + ": " + value.toString();
    }
}
