/*
 * File:     CVEntryRecord.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.dobes;


/**
 * Stores information needed to construct a CVEntry object.
 *
 * @see mpi.util.CVEntry
 *
 * @author Han Sloetjes
 * @version jun 2004
 */
public class CVEntryRecord {
    private String description;
    private String value;
    private String extRefId;

    /**
     * Returns the description.
     * @return the description, or null
     */
    public String getDescription() {
        return description;
    }

    /**
     * Returns the value.
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the description.
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Sets the value.
     * @param value the value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Returns the id of an external reference object
     *
     * @return the extRefId the id of an external reference, e.g. a concept defined in ISO DCR
     */
    public String getExtRefId() {
        return extRefId;
    }

    /**
     * Sets the external reference id.
     *
     * @param extRefId the extRefId to set
     */
    public void setExtRefId(String extRefId) {
        this.extRefId = extRefId;
    }
}
