/*
 * File:     TimeSlotRecordComparator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Comparator;


/**
 * A comparator class that compares 2 timeslot records by first comparing the time value 
 * and next the id.
 * 
 * @author Han Sloetjes
 */
public class TimeSlotRecordComparator implements Comparator {
    /**
 * Constructor
 */
    public TimeSlotRecordComparator() {
        super();
    }

    /**
 * Compares 2 timeslot records, by first comparing their time value and then their id or index.
 * 
 * @param o1 the first record
 * @param o2 the second record
 * 
 * @throws ClassCastException if one if the arguments is not a TimeSlotRecord
 */
    public int compare(Object o1, Object o2) throws ClassCastException {
        TimeSlotRecord tsr1 = (TimeSlotRecord) o1;
        TimeSlotRecord tsr2 = (TimeSlotRecord) o2;

        if (tsr1.getValue() < tsr2.getValue()) {
            return -1;
        }

        if (tsr1.getValue() > tsr2.getValue()) {
            return 1;
        }

        if (tsr1.getValue() == tsr2.getValue()) {
            if (tsr1.getId() < tsr2.getId()) {
                return -1;
            }

            if (tsr1.getId() > tsr2.getId()) {
                return 1;
            }
        }

        return 0;
    }
}
