/*
 * File:     FlexConstants.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.flex;


/**
 * Constants for parsing Flex files
 *
 * @author Han Sloetjes
 * @version 1.0
  */
public interface FlexConstants {
    /** the element document */
    public static final String DOC = "document";

    /** the element interlinear-text */
    public static final String IT = "interlinear-text";

    /** the element paragraph */
    public static final String PARAGR = "paragraph";

    /** the element phrase */
    public static final String PHRASE = "phrase";

    /** the element word */
    public static final String WORD = "word";

    /** the element morph */
    public static final String MORPH = "morph";

    /** the element item */
    public static final String ITEM = "item";

    /** the attribute type */
    public static final String TYPE = "type";

    /** the attribute lang */
    public static final String LANG = "lang";

    /** the element language */
    public static final String LANGUAGE = "language";

    /** the attribute txt */
    public static final String TXT = "txt";

    /** a general gloss */
    public static final String GLS = "gloss";

    /** the attribute punct */
    public static final String PUNCT = "punct";

    /** the attribute guid */
    public static final String GUID = "guid";

    /** Holds value of property DOCUMENT ME! */
    public static final String FLEX_GUID_ANN_PREFIX = "a_";
}
