/*
 * File:     MarkerRecord.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Jul 1, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.Serializable;


/**
 * @author hennie
 */
public class MarkerRecord implements Serializable {
    // character encoding

    /** Holds value of property DOCUMENT ME! */
    public static final int UTF8 = 0;

    /** Holds value of property DOCUMENT ME! */
    public static final int ISOLATIN = 1;

    /** Holds value of property DOCUMENT ME! */
    public static final int SILIPA = 2;

    /** Holds value of property DOCUMENT ME! */
    public static final String ISOLATINSTRING = "ISO-Latin-1";

    /** Holds value of property DOCUMENT ME! */
    public static final String UNICODESTRING = "Unicode (UTF-8)";

    /** Holds value of property DOCUMENT ME! */
    public static final String SILIPASTRING = "SIL IPA";

    /** Holds value of property DOCUMENT ME! */
    public static final String[] charsetStrings = {
        ISOLATINSTRING, UNICODESTRING, SILIPASTRING
    };
    private String marker;
    private String parentMarker;
    private String stereoType;
    private String charsetString;
    private boolean participantMarker = false;
    private boolean exclude = false;

    /**
     * @return
     */
    public String getCharsetString() {
        return charsetString;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getCharset() {
        int charset = -1;

        if (charsetString.equals(ISOLATINSTRING)) {
            charset = ISOLATIN;
        } else if (charsetString.equals(UNICODESTRING)) {
            charset = UTF8;
        } else if (charsetString.equals(SILIPASTRING)) {
            charset = SILIPA;
        }

        return charset;
    }

    /**
     * @return
     */
    public String getMarker() {
        return marker;
    }

    /**
     * @return
     */
    public String getParentMarker() {
        return parentMarker;
    }

    /**
     * @return
     */
    public String getStereoType() {
        return stereoType;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean getParticipantMarker() {
        return participantMarker;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isExcluded() {
        return exclude;
    }

    /**
     * @param string
     */
    public void setCharset(String charset) {
        this.charsetString = charset;
    }

    /**
     * @param string
     */
    public void setMarker(String string) {
        marker = string;
    }

    /**
     * @param string
     */
    public void setParentMarker(String string) {
        parentMarker = string;
    }

    /**
     * @param string
     */
    public void setStereoType(String string) {
        stereoType = string;
    }

    /**
     * DOCUMENT ME!
     *
     * @param bool DOCUMENT ME!
     */
    public void setParticipantMarker(boolean bool) {
        participantMarker = bool;
    }

    /**
     * DOCUMENT ME!
     *
     * @param bool DOCUMENT ME!
     */
    public void setExcluded(boolean bool) {
        exclude = bool;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return "marker:      " + marker + "\n" + "parent:      " +
        parentMarker + "\n" + "stereotype:  " + stereoType + "\n" +
        "charset:     " + charsetString + "\n" + "exclude:     " + exclude +
        "\n" + "participant: " + participantMarker + "\n";
    }
}
