/*
 * File:     SimpleToolboxLine.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;


/**
 * Holds a line of a marker that is not part of an interlinearized
 * group of markers. Is one-to-one related to the record marker or
 * another SimpleToolboxLine.
 *
 * @author Han Sloetjes
 * @version 1.0
  */
public class SimpleToolboxLine implements ToolboxLine {
    private ToolboxLine parent;
    private String marker = "";
    private String line = "";

    /**
     * Creates a new SimpleToolboxLine instance
     *
     * @param marker the marker
     * @param line the (first) line of this marker in a record
     */
    public SimpleToolboxLine(String marker, String line) {
        this.marker = marker;
        this.line = line;
    }

    /**
     * Returns the parent line.
     *
     * @return the parent
     */
    public ToolboxLine getParent() {
        return parent;
    }

    /**
     * Sets the parent line
     *
     * @param parent the parent to set
     */
    public void setParent(ToolboxLine parent) {
        this.parent = parent;
    }

    /**
     * Returns the marker name
     *
     * @return the marker name
     */
    public String getMarkerName() {
        return marker;
    }

    /**
     * Appends a line, if the same marker has multiple lines in a record.
     *
     * @param appLine the line to append
     */
    public void appendLine(String appLine) {
        if (appLine != null) {
            line = line + " " + appLine;
        }
    }

    /**
     * Returns the line.
     *
     * @return the line
     */
    public String getLine() {
        return line;
    }
}
