/*
 * File:     ToolboxDecoderInfo2.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.File;

import java.util.List;


/**
 * A subclass holding a reference to a toolbox typ file and some flags for the
 * Toolbox Parser.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class ToolboxDecoderInfo2 extends ToolboxDecoderInfo {
    private ToolboxTypFile toolboxTypFile;
    private boolean recalculateForCharBytes = true;

    /**
     * Creates a new ToolboxDecoderInfo2 instance
     */
    public ToolboxDecoderInfo2() {
        super();
    }

    /**
     * Creates a new ToolboxDecoderInfo2 instance
     *
     * @param shoeboxFilePath the path to a Toolbox file
     */
    public ToolboxDecoderInfo2(String shoeboxFilePath) {
        super(shoeboxFilePath);
    }

    /**
     * @see mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo#setShoeboxMarkers(java.util.List)
     */
    public void setShoeboxMarkers(List shoeboxMarkers) {
        super.setShoeboxMarkers(shoeboxMarkers);

        if ((shoeboxMarkers == null) || (shoeboxMarkers.size() == 0)) {
            throw new IllegalArgumentException("No markers specified");
        }

        toolboxTypFile = new ToolboxTypFile(shoeboxMarkers);
    }

    /**
     * @see mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo#setTypeFile(java.lang.String)
     */
    public void setTypeFile(String typeFile) {
        super.setTypeFile(typeFile);

        if (typeFile == null) {
            throw new IllegalArgumentException("No .typ file specified");
        }

        File tpFile = new File(typeFile);
        toolboxTypFile = new ToolboxTypFile(tpFile);
    }

    /**
     * Returns the Toolbox typ file object
     *
     * @return the toolboxTypFile
     */
    public ToolboxTypFile getToolboxTypFile() {
        return toolboxTypFile;
    }

    /**
     * Returns whether the alignment should be recalculated based on the number
     * of bytes per character. Is user definable
     *
     * @return the recalculateForCharBytes flag
     */
    public boolean isRecalculateForCharBytes() {
        return recalculateForCharBytes;
    }

    /**
     * Sets whether the alignment should be recalculated based on the number of
     * bytes per character.
     *
     * @param recalculateForCharBytes if true indices of individual words are
     *        recalculated based on the number of bytes per character
     */
    public void setRecalculateForCharBytes(boolean recalculateForCharBytes) {
        this.recalculateForCharBytes = recalculateForCharBytes;
    }
}
