/*
 * File:     ToolboxLine.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;


/**
 * Interface for a Toolbox line, consisting of a marker name and a line (that
 * can either be simple or complex).
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public interface ToolboxLine {
    /**
     * Returns the parent Toolbox line
     *
     * @return the parent line
     */
    public ToolboxLine getParent();

    /**
     * Sets the parent ToolboxLine for this line.
     *
     * @param toolboxLine the parent
     */
    public void setParent(ToolboxLine toolboxLine);

    /**
     * Returns the marker name of the ToolboxLine. Equivalent (more or less) to
     * an ELAN tier name
     *
     * @return the marker name
     */
    public String getMarkerName();

    /**
     * Appends a line to the ToolboxLine. Used in case of Toolbox records with
     * wrapped marker lines.
     *
     * @param appLine the line to append to the current line
     */
    public void appendLine(String appLine);
}
