/*
 * File:     ToolboxWord.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;


/**
 * Helper class with public access to index values.
 *
 * @author Han Sloetjes
 */
public class ToolboxWord {
    /** the real "x" position of the first character of a word in the Java string */
    public int realX;

    /** the recalculated "x" position of the first character; the recalculation is based
     * on number of non-spacing characters in the string as well as the number of
     * bytes per character */
    public int calcX;

    /** the real, Java string, width of the word, the number of characters */
    public int realW;

    /** the recalculated width, based on number of non-spacing characters and number
     * of bytes per character */
    public int calcW;

    /** the actual word or unit */
    public String word = "";
    private String marker = "";

    /**
     * Creates a new empty ToolboxWord instance
     */
    public ToolboxWord() {
    }

    /**
     * Creates a new ToolboxWord instance of the specified word
     *
     * @param word the word or unit value
     */
    public ToolboxWord(String word) {
        this.word = word;
    }

    /**
     * Creates a new ToolboxWord instance
     *
     * @param marker the marker this word is part of
     * @param word the word or unit
     */
    public ToolboxWord(String marker, String word) {
        this.marker = marker;
        this.word = word;
    }

    /**
     * Sets the marker name.
     *
     * @param marker the marker to set
     */
    public void setMarkerName(String marker) {
        this.marker = marker;
    }

    /**
     * Returns the marker name.
     *
     * @return the marker name
     */
    public String getMarkerName() {
        return marker;
    }
}
