/*
 * File:     ByteRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Sep 24, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import mpi.eudico.server.corpora.clom.Annotation;

import java.util.Iterator;
import java.util.Vector;


/**
 * @author hennie
 */
public class ByteRenderer extends Renderer {
    /**
     * DOCUMENT ME!
     *
     * @param metrics DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static String[] render(Metrics metrics) {
        String[] outputLines = new String[metrics.getMaxVerticalPosition() + 1];

        // initialize
        for (int i = 0; i < outputLines.length; i++) {
            outputLines[i] = "";
        }

        //		renderTierLabels(metrics, outputLines);
        renderAnnotationValues(metrics, outputLines);

        return outputLines;
    }

    /**
     * DOCUMENT ME!
     *
     * @param metrics DOCUMENT ME!
     * @param outputLines DOCUMENT ME!
     */
    public static void renderTierLabels(Metrics metrics, String[] outputLines) {
        Integer vPos = null;
        String tierLabel = "";

        Vector vPositions = metrics.getPositionsOfNonEmptyTiers();

        Iterator posIter = vPositions.iterator();

        while (posIter.hasNext()) {
            vPos = (Integer) posIter.next();
            tierLabel = metrics.getTierLabelAt(vPos.intValue());

            outputLines[vPos.intValue()] += (tierLabel + " ");
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param metrics DOCUMENT ME!
     * @param outputLines DOCUMENT ME!
     */
    public static void renderAnnotationValues(Metrics metrics,
        String[] outputLines) {
        Vector annots = metrics.getBlockWiseOrdered();

        Iterator annIter = annots.iterator();

        while (annIter.hasNext()) {
            Annotation a = (Annotation) annIter.next();
            int vPos = metrics.getVerticalPosition(a);
            int hPos = metrics.getHorizontalPosition(a);

            String tierLabel = metrics.getTierLabelAt(vPos);

            if (!(metrics.getInterlinearizer().getCharEncoding(tierLabel) == Interlinearizer.UTF8)) {
                outputLines[vPos] += (nSpaces(hPos -
                    outputLines[vPos].length()) + a.getValue());
            } else {
                outputLines[vPos] += (nSpaces(hPos -
                    SizeCalculator.getNumOfBytes(outputLines[vPos])) +
                a.getValue());
            }
        }
    }

    private static String nSpaces(int n) {
        String ret = "";

        for (int i = 0; i < n; i++) {
            ret += " ";
        }

        return ret;
    }
}
