/*
 * File:     TranscriberDecoderInfo.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.transcriber;

import mpi.eudico.server.corpora.clom.DecoderInfo;


/**
 * A decoderinfo object for Toolbox/Shoebox files.
 */
public class TranscriberDecoderInfo implements DecoderInfo {
    private boolean singleTierForSpeakers = false;
    private String sourceFilePath;

    /**
     * Creates a new TranscriberDecoderInfo object
     */
    public TranscriberDecoderInfo(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    /**
     * Returns the path to the Transcriber file
     * @see mpi.eudico.server.corpora.clom.DecoderInfo#getSourceFilePath()
     */
    public String getSourceFilePath() {
        return sourceFilePath;
    }

    /**
     * Returns whether each speaker should have its own tier.
     *
     * @return true if all utterances should be stored on one tier
     */
    public boolean isSingleSpeakerTier() {
        return singleTierForSpeakers;
    }

    /**
     * Sets whether each speaker should have its own tier.
     *
     * @param singleTierForSpeakers if true all utterances will be created on one tier
     */
    public void setSingleSpeakerTier(boolean singleTierForSpeakers) {
        this.singleTierForSpeakers = singleTierForSpeakers;
    }
}
